package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Obtention des informations sur l'algorithme
 *
 */
public class InfoAlgo{

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(InfoAlgo.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSlotToken Identifiant du slot hbergeant la carte
	 * @param idAlgo Identifiant de l'algorithme
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSlotToken, long idAlgo) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {		
		
				ResultatInfo resultat = new ResultatInfo("Obtenir des informations sur l'algorithme ");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);
				
				try {
					
					// Rcupration du libell de la carte
					CK_TOKEN_INFO info = librairie.C_GetTokenInfo(idSlotToken);
					if(info != null)
						resultat.appendTraitement(TraitementsUtil.getNomAlgo(idAlgo).replaceAll("_", " ").replaceAll("CKM", "").trim()+" de la carte "+new String(info.label).trim()+" (C_GetMechanismInfo)");
					else
						resultat.appendTraitement("(C_GetMechanismInfo)");
					
				} catch (PKCS11Exception e) {
					
					// On ne fait rien, il ne s'agit pas de la fonction que l'on teste dans ce traitement
					
				}
					
				// Rcupration des informations sur l'algorithme
				try {
		
					// Traitement  tester
					CK_MECHANISM_INFO info = librairie.C_GetMechanismInfo(idSlotToken,idAlgo);
					
					if(info != null) {
						
						// Formatage du resultat
						infos.put("Taille minimale de la cl pour l'algorithme (l'unit de grandeur (bits ou octets) dpend du type d'algorithme)?",Long.toString(info.ulMinKeySize));
						infos.put("Taille maximale de la cl pour l'algorithme (l'unit de grandeur (bits ou octets) dpend du type d'algorithme)?",Long.toString(info.ulMaxKeySize));
						infos.put("L'algorithme est-il directement appliqu sur la carte?",(info.flags & PKCS11Constants.CKF_HW)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour le chiffrement?",(info.flags & PKCS11Constants.CKF_ENCRYPT)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour le dchiffrement?",(info.flags & PKCS11Constants.CKF_DECRYPT)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour raliser un condensat?",(info.flags & PKCS11Constants.CKF_DIGEST)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour raliser une signature?",(info.flags & PKCS11Constants.CKF_SIGN)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour rcuprer une donne depuis une signature?",(info.flags & PKCS11Constants.CKF_SIGN_RECOVER)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour raliser la vrification dune signature ou dun MAC (Message Authentication Code)?",(info.flags & PKCS11Constants.CKF_VERIFY)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour raliser la vrification dune signature ou dun MAC (Message Authentication Code) avec rcupration de la donne depuis la signature?",(info.flags & PKCS11Constants.CKF_VERIFY_RECOVER)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour gnrer une cl secrte?",(info.flags & PKCS11Constants.CKF_GENERATE)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour gnrer une paire de cls (publique/prive)?",(info.flags & PKCS11Constants.CKF_GENERATE_KEY_PAIR)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour chiffrer une cl?",(info.flags & PKCS11Constants.CKF_WRAP)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour dchiffrer une cl?",(info.flags & PKCS11Constants.CKF_UNWRAP)!=0?"Oui":"Non");
						infos.put("L'algorithme peut-il tre utilis pour driver une cl depuis une autre cl?",(info.flags & PKCS11Constants.CKF_DERIVE)!=0?"Oui":"Non");
					
					} else {
						
						// Si les informations sont nulles on lve l'exception
						log.error("L'operation a retourne des informations nulles");
						throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_LISTE_ALGO, "L'opration a retourn des informations nulles");
						
					}
		
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
		
				return resultat;
				
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_ALGO, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INFO_ALGO, "Une erreur inattendue est survenue");
			
		}
				
	}

}
